* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Table 4 (data row)
use year R_frac_hp using "$datapath/macrodata_coopimmo.dta", clear
merge 1:1 year using "$datapath/RBC_data.dta", nogen

* Correlations
qui pwcorr GDP_hp C_hp
gen c_Y_C = r(rho)

qui pwcorr GDP_hp I_hp
gen c_Y_I = r(rho)

qui pwcorr C_hp I_hp
gen c_C_I = r(rho)

qui pwcorr GDP_hp SR_hp
gen c_Y_A = r(rho)

qui pwcorr GDP_hp R_frac_hp
gen c_Y_R = r(rho)

collapse (sd) C_hp I_hp GDP_hp (mean) c_*

* Construct relative standard deviations

gen C_sd 	= C_hp / GDP_hp
gen I_sd 	= I_hp / GDP_hp

drop C_hp I_hp GDP_hp

save "$mainpath/Tables/Tables_data/Table4.dta", replace
